#ifndef __BROWSEVIEW_COLUMN_H__
#define __BROWSEVIEW_COLUMN_H__

class EntnodeData;

// context in which a collumn is accessed
class KoColumnContext
{
// Attributes
public:
	CString m_path;
	// current path

public:
	KoColumnContext(LPCTSTR path)
	: m_path(path)
	{}	
};

//  column descriptor interface
class KiColumn 
{
// Interfaces
public:
	// retrieve setup data
	virtual void GetSetupData(LV_COLUMN* lvc) const = 0;

	// tells if the column shall be sorted ascending initially
	virtual bool IsDefaultAscending() const = 0;

	// retrieve formatted text as pertained to a node
	virtual void GetText(KoColumnContext* context, EntnodeData* data, char* buffer, int buffersize) const = 0;

	// compare two nodes (-1,0,+1)
	virtual int Compare(KoColumnContext* context, EntnodeData* d1, EntnodeData* d2) const = 0;
};

// columnar model of the data		
class KiColumnModel
{
// Interfaces
public:
	virtual const KiColumn* GetAt(int pos) const = 0;
	// gets column descriptor by its index

	virtual int GetCount() const = 0;
	// returns count of the columns

// Factory methods
public:
	static KiColumnModel* GetRecursiveModel();
	static KiColumnModel* GetRegularModel();
};

#endif
// __BROWSEVIEW_COLUMN_H__
