#ifndef _CVSCOWORKERERROR_H_
#define _CVSCOWORKERERROR_H_

//
//  Likely errors to be returned from coworker API.
//  Will expand or shrink this list as needed.
//

// Returns from OpenProject()
#define CVS_E_FAILED_OPEN_PROJECT           MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,100)
#define CVS_E_FAILED_OPEN_DISALLOWED        MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,101)
#define CVS_E_FAILED_OPEN_INVALID_USER      MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,102)
#define CVS_E_FAILED_OPEN_CREATE            MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,103)
#define CVS_E_FAILED_OPEN_BAD_PATH          MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,104)

// Returns from CloseProject()
#define CVS_E_FAILED_CLOSE_PROJECT          MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,200)

// Returns from UpdateFiles()
#define CVS_E_FAILED_UPDATE_FILES           MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,300)
#define CVS_E_FAILED_UPDATE_DISALLOWED      MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,301)
#define CVS_E_FAILED_UPDATE_NOT_IN_CVS      MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,302)

// Return from CheckoutFiles()
#define CVS_E_FAILED_CHECKOUT_FILES         MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,400)
#define CVS_E_FAILED_CHECKOUT_DISALLOWED    MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,401)
#define CVS_E_FAILED_CHECKOUT_NOT_IN_CVS    MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,402)

// Return from CheckinFiles()
#define CVS_E_FAILED_CHECKIN_FILES          MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,500)
#define CVS_E_FAILED_CHECKIN_DISALLOWED     MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,501)
#define CVS_E_FAILED_CHECKIN_NOT_IN_CVS     MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,502)
#define CVS_E_FAILED_CHECKIN_NEED_UPDATE    MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,503)

// Returns common to many functions.
#define CVS_E_FAILED_PROJECT_INVALID        MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,9900)
#define CVS_E_FAILED                        MAKE_HRESULT(SEVERITY_ERROR,FACILITY_ITF,9901)

#endif

