/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * plugin.h modified for the cvsgui project by :
 * Alexandre Parenteau <aubonbeurre@hotmail.com> --- November 1999
 */

#ifndef CVSGUI_PROCESS_H
#define CVSGUI_PROCESS_H

#include <sys/types.h>
#include "cvsgui_wire.h"

#define WRITE_BUFFER_SIZE  512

typedef struct _CvsProcess             CvsProcess;

typedef struct
{
	long (*consoleout)(char *txt, long len);	/* Get cvs stdout */
	long (*consoleerr)(char *txt, long len);	/* Get cvs stderr */
	char *(*getenv)(char *name);				/* Ask about env. variable */
	void (*exit)(int code);						/* Tells the exit code */
} CvsProcessCallbacks;

struct _CvsProcess
{
	unsigned int open : 1;					/* Is the process open */
	unsigned int destroy : 1;				/* Should the process by destroyed */
	unsigned int synchronous : 1; 			/* Is the process running synchronously or not */
	pid_t pid;								/* process process id */
	char **args;							/* process command line arguments */
	int argc;

	int my_read, my_write;					/* Apps read and write file descriptors */
	int his_read, his_write;				/* process read and write file descriptors */

	char write_buffer[WRITE_BUFFER_SIZE];	/* Buffer for writing */
	int write_buffer_index;					/* Buffer index for writing */
	CvsProcessCallbacks *callbacks;			/* Jump table */
};

#ifdef __cplusplus
extern "C" {
#endif

/* Open a process. This cause the process to run.
 */
CvsProcess *cvs_process_open (char *name, int argc, char **argv,
							  CvsProcessCallbacks *callbacks);

/* Close a process. This kills the process and releases
 *  its resources.
 */
void cvs_process_kill(CvsProcess *cvs_process);

/* Initialize initialize the protocol library (both for the
 * process and the application)
 */
void cvs_process_init (void);

/*
 * Called by the application to answer calls from the process
 */
void cvs_process_give_time(void);

/*
 * Tells if the process is still alive
 */
int cvs_process_is_active(CvsProcess *cvs_process);

/*
 * Kills the process
 */

#ifdef __cplusplus
}
#endif

#endif /* CVSGUI_PROCESS_H */
