/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

/*
 * MacMisc.cpp --- misc. utilities for mac
 */

#include "MacMisc.h"

Handle
GetDItemHdl(DialogPtr dlg, SInt16 Id)
{
	SInt16	type;
	Handle	item;
	Rect	box;
	
	GetDialogItem(dlg, Id, &type, &item, &box);
	return item;
}

ControlHandle
GetDItemCtrlHdl(DialogPtr dlg, SInt16 Id)
{
	SInt16	type;
	Handle	item;
	Rect	box;
	
	GetDialogItem(dlg, Id, &type, &item, &box);
	return (ControlHandle)item;
}

SInt16 GetDItemMenuSel(DialogPtr dlg, SInt16 Id)
{
	ControlHandle ctrl = GetDItemCtrlHdl(dlg, Id);
	return ctrl != 0L ? GetControlValue(ctrl) : 0;
}

void SetDItemMenuSel(DialogPtr dlg, SInt16 Id, SInt16 sel)
{
	ControlHandle ctrl = GetDItemCtrlHdl(dlg, Id);
	if(ctrl != 0L)
		SetControlValue(ctrl, sel);
}

pascal	OSErr	FSMakeFSSpecCompat(short vRefNum,
								   long dirID,
								   ConstStr255Param fileName,
								   FSSpec & spec)
{
	OSErr	result;
	
	/* Let the file system create the FSSpec if it can since it does the job */
	/* much more efficiently than I can. */
	result = FSMakeFSSpec(vRefNum, dirID, fileName, &spec);
	/* Fix a bug in Macintosh PC Exchange's MakeFSSpec code where 0 is */
	/* returned in the parID field when making an FSSpec to the volume's */
	/* root directory by passing a full pathname in MakeFSSpec's */
	/* fileName parameter. */
	if ( (result == noErr) && (spec.parID == 0) )
		spec.parID = fsRtParID;
	
	return ( result );
}

int stricmp(const char *str1, const char *str2)
{
	unsigned char c1, c2;
	
	while(1)
	{
		c1 = (unsigned char)*str1++;
		c2 = (unsigned char)*str2++;
		if(c1 == '\0' || c2 == '\0') break;
		
		if((c1 < 'A' || c1 > 'Z') && (c1 < 'a' || c1 > 'z'))
		{
			if(c1 != c2) break;
		}
		else if((c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z'))
			break;
		else
		{
			c1 &= 0xDF;
			c2 &= 0xDF;
			if(c1 != c2)
				break;
		}
	}
	
	return c1 == c2 ? 0 : (c1 < c2 ? -1 : 1);
}

int strnicmp(const char *str1, const char *str2, unsigned long n)
{
	unsigned char c1 = 0, c2 = 0;
	
	while(n--)
	{
		c1 = (unsigned char)*str1++;
		c2 = (unsigned char)*str2++;
		if(c1 == '\0' || c2 == '\0') break;
		
		if((c1 < 'A' || c1 > 'Z') && (c1 < 'a' || c1 > 'z'))
		{
			if(c1 != c2) break;
		}
		else if((c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z'))
			break;
		else
		{
			c1 &= 0xDF;
			c2 &= 0xDF;
			if(c1 != c2)
				break;
		}
	}
	
	return c1 == c2 ? 0 : (c1 < c2 ? -1 : 1);
}
