/* LIBGIMP - The GIMP Library                                                   
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball                
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.             
 *                                                                              
 * This library is distributed in the hope that it will be useful,              
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * gimpwire.h modified for the cvsgui project by :
 * Alexandre Parenteau <aubonbeurre@hotmail.com> --- November 1999
 */

#ifndef CVSGUI_WIRE_H
#define CVSGUI_WIRE_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __G_LIB_H__
typedef signed char gint8;
typedef unsigned char guint8;
typedef signed short gint16;
typedef unsigned short guint16;
typedef signed int gint32;
typedef unsigned int guint32;

typedef char   gchar;
typedef short  gshort;
typedef long   glong;
typedef int    gint;
typedef gint   gboolean;

typedef unsigned char	guchar;
typedef unsigned short	gushort;
typedef unsigned long	gulong;
typedef unsigned int	guint;

typedef float	gfloat;
typedef double	gdouble;

typedef void* gpointer;
typedef const void *gconstpointer;

#ifndef	FALSE
#define	FALSE	(0)
#endif

#ifndef	TRUE
#define	TRUE	(!FALSE)
#endif
#endif // !__G_LIB_H__

typedef struct _WireMessage  WireMessage;

typedef void (* WireReadFunc)    (int fd, WireMessage *msg);
typedef void (* WireWriteFunc)   (int fd, WireMessage *msg);
typedef void (* WireDestroyFunc) (WireMessage *msg);
typedef int  (* WireIOFunc)      (int fd, guint8 *buf, gulong count);
typedef int  (* WireFlushFunc)   (int fd);


struct _WireMessage
{
  guint32 type;
  gpointer data;
};


void wire_register     (guint32          type,
		        WireReadFunc     read_func,
		        WireWriteFunc    write_func,
		        WireDestroyFunc  destroy_func);
void wire_set_reader   (WireIOFunc       read_func);
void wire_set_writer   (WireIOFunc       write_func);
void wire_set_flusher  (WireFlushFunc    flush_func);
int  wire_read         (int              fd,
			guint8          *buf,
			gulong           count);
int  wire_write        (int              fd,
			guint8          *buf,
			gulong           count);
int  wire_flush        (int              fd);
int  wire_error        (void);
void wire_clear_error  (void);
int  wire_read_msg     (int              fd,
		        WireMessage     *msg);
int  wire_write_msg    (int              fd,
		        WireMessage     *msg);
void wire_destroy      (WireMessage     *msg);
int  wire_read_int32   (int              fd,
		        guint32         *data,
		        gint             count);
int  wire_read_int16   (int              fd,
		        guint16         *data,
		        gint             count);
int  wire_read_int8    (int              fd,
		        guint8          *data,
		        gint             count);
int  wire_read_double  (int              fd,
		        gdouble         *data,
		        gint             count);
int  wire_read_string  (int              fd,
			gchar          **data,
			gint             count);
int  wire_write_int32  (int              fd,
		        guint32         *data,
		        gint             count);
int  wire_write_int16  (int              fd,
		        guint16         *data,
		        gint             count);
int  wire_write_int8   (int              fd,
		        guint8          *data,
		        gint             count);
int  wire_write_double (int              fd,
			gdouble         *data,
			gint             count);
int  wire_write_string (int              fd,
			gchar          **data,
			gint             count);

#ifdef __cplusplus
}
#endif

#endif /* CVSGUI_WIRE_H */
